unit socket;

interface

uses ScktComp, Classes, SyncObjs, Windows, Dialogs, Forms, SysUtils, Contnrs;

type
  {$M+}
  TMyClientSocket = class
  private
    FCritical: TCriticalSection;
    FError: Boolean;
    FHasResponse: Boolean;
    FRequest: String;
    FResponse: String;
    FSocket: TClientSocket;

    FHost: String;
    FIP: String;
    FPort: Integer;

    procedure OnConnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure OnDisconnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure OnError(Sender: TObject; Socket: TCustomWinSocket; ErrorEvent: TErrorEvent; var ErrorCode: Integer);
    procedure OnRead(Sender: TObject; Socket: TCustomWinSocket);
    procedure OnWrite(Sender: TObject; Socket: TCustomWinSocket);
    procedure SendRequest(Request: String);

    procedure SetIP(const Value: String);
    procedure SetPort(const Value: Integer);
    procedure SetHost(const Value: String);
  public
    constructor Create;
    destructor Destroy; override;
  published
    property Error: Boolean read FError write FError;
    property Host: String read FHost write SetHost;
    property IP: String read FIP write SetIP;
    property Port: Integer read FPort write SetPort;
    property Response: String read FResponse write FResponse;

    procedure AddRequest(Request: String);
    procedure ShowResponse(const S: String);
    procedure WaitForData;
  end;
  {$M-}

implementation

{ TMyClientSocket }

procedure TMyClientSocket.AddRequest(Request: String);
begin
  SendRequest(Request);
end;

constructor TMyClientSocket.Create;
begin
  inherited Create;

  FCritical := TCriticalSection.Create;
  FSocket := TClientSocket.Create(nil);

  FSocket.ClientType := ctNonBlocking;
  FSocket.OnConnect := OnConnect;
  FSocket.OnRead := OnRead;
  FSocket.OnWrite := OnWrite;
  FSocket.OnDisconnect := OnDisconnect;
  FSocket.OnError := OnError;
end;

destructor TMyClientSocket.Destroy;
begin
  inherited;
  try
    FCritical.Free;
    FSocket.Close;
    FSocket.Free;
  except
  end;
end;

procedure TMyClientSocket.OnConnect(Sender: TObject; Socket: TCustomWinSocket);
begin
  Socket.SendText(FRequest);
end;

procedure TMyClientSocket.OnDisconnect(Sender: TObject; Socket: TCustomWinSocket);
begin
  FResponse := FResponse +Socket.ReceiveText;
  FHasResponse := true;
end;

procedure TMyClientSocket.OnError(Sender: TObject; Socket: TCustomWinSocket; ErrorEvent: TErrorEvent; var ErrorCode: Integer);
begin
  FError := true;
  ErrorCode := 0;
  Socket.Close;
end;

procedure TMyClientSocket.OnRead(Sender: TObject; Socket: TCustomWinSocket);
begin
  FResponse := FResponse +Socket.ReceiveText;
end;

procedure TMyClientSocket.OnWrite(Sender: TObject; Socket: TCustomWinSocket);
begin
end;

procedure TMyClientSocket.SendRequest(Request: String);
begin
  FRequest := Request;
  FResponse := '';
  FHasResponse := false;
  FError := false;

  FSocket.Close;
  FSocket.Port := FPort;
  FSocket.Open;
end;

procedure TMyClientSocket.SetHost(const Value: String);
begin
  FHost := Value;
  FSocket.Host := Value;
  FSocket.Address := '';
end;

procedure TMyClientSocket.SetIP(const Value: String);
begin
  FIP := Value;
  FSocket.Address := Value;
  FSocket.Host := '';
end;

procedure TMyClientSocket.SetPort(const Value: Integer);
begin
  FPort := Value;
  FSocket.Port := Value;
end;

procedure TMyClientSocket.ShowResponse(const S: String);
begin
  ShowMessage(s);
end;

procedure TMyClientSocket.WaitForData;
begin
  while (not FHasResponse) and (not FError) do
    Application.ProcessMessages;
end;

end.
